#include <GL/glut.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
int const scrwdth=768, scrhght=512;
int *texture, *copytex;
int toggle=0,mode=0, spframe=0,lastframe=0;
double trgb[4][4];
FILE *fp;

typedef struct{
	int texture[256];
	double colour1[4]={0.5,0.5,0.5,0.7},colour2[4]={0.3,0.3,0.3,0.7},colour3[4]={0.5,0.5,0.5,0.7},colour4[4]={0.3,0.3,0.3,0.7};
}walltextures;
walltextures savewall;
typedef struct{
	double center[2];
	double top, bottom;
}slider;
slider sliders[4][4], previous, next, copy, paste, flip;

typedef struct{
	int front[3][256], back[3][256], left[3][256], right[3][256], dead[256];
	double colour1[3]={0,0,0},colour2[3]={0,0,0},colour3[3]={0,0,0},colour4[3]={0,0,0};
}spritetextures;
spritetextures focustexture;

void drawspecs(){
	char modestr[64];
	int length;
	if(mode){
		switch(spframe){
			case 0:
			strcpy(modestr,"Sprite front walking 1");
			break;
			case 1:
			strcpy(modestr,"Sprite front middle");
			break;
			case 2:
			strcpy(modestr,"Sprite front walking 2");
			break;
			case 3:
			strcpy(modestr,"Sprite back walking 1");
			break;
			case 4:
			strcpy(modestr,"Sprite back middle");
			break;
			case 5:
			strcpy(modestr,"Sprite back walking 2");
			break;
			case 6:
			strcpy(modestr,"Sprite left walking 1");
			break;
			case 7:
			strcpy(modestr,"Sprite left middle");
			break;
			case 8:
			strcpy(modestr,"Sprite left walking 2");
			break;
			case 9:
			strcpy(modestr,"Sprite right walking 1");
			break;
			case 10:
			strcpy(modestr,"Sprite right middle");
			break;
			case 11:
			strcpy(modestr,"Sprite right walking 2");
			break;
			case 12:
			strcpy(modestr,"Sprite dead");
			break;
		}
		glColor3f(0,0,0);
		glRasterPos2f(544,460);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		strcpy(modestr,"<-");
		glRasterPos2f(previous.center[0]-8,previous.center[1]-16);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		strcpy(modestr,"->");
		glRasterPos2f(next.center[0]-8,next.center[1]-16);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		strcpy(modestr,"<>");
		glRasterPos2f(flip.center[0]-8,flip.center[1]-16);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		strcpy(modestr,"cp");
		glRasterPos2f(copy.center[0]-8,copy.center[1]-16);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		strcpy(modestr,"ps");
		glRasterPos2f(paste.center[0]-8,paste.center[1]-16);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
		glColor3f(0.5,0,0);
		glBegin(GL_QUADS);
		glVertex2i(previous.center[0]-8,previous.center[1]+8);
		glVertex2i(previous.center[0]-8,previous.center[1]-8);
		glVertex2i(previous.center[0]+8,previous.center[1]-8);
		glVertex2i(previous.center[0]+8,previous.center[1]+8);
		glEnd();
		glColor3f(0.5,0.5,0);
		glBegin(GL_QUADS);
		glVertex2i(copy.center[0]-8,copy.center[1]+8);
		glVertex2i(copy.center[0]-8,copy.center[1]-8);
		glVertex2i(copy.center[0]+8,copy.center[1]-8);
		glVertex2i(copy.center[0]+8,copy.center[1]+8);
		glEnd();
		glColor3f(0,0.5,0.5);
		glBegin(GL_QUADS);
		glVertex2i(flip.center[0]-8,flip.center[1]+8);
		glVertex2i(flip.center[0]-8,flip.center[1]-8);
		glVertex2i(flip.center[0]+8,flip.center[1]-8);
		glVertex2i(flip.center[0]+8,flip.center[1]+8);
		glEnd();
		glColor3f(0,0.5,0);
		glBegin(GL_QUADS);
		glVertex2i(paste.center[0]-8,paste.center[1]+8);
		glVertex2i(paste.center[0]-8,paste.center[1]-8);
		glVertex2i(paste.center[0]+8,paste.center[1]-8);
		glVertex2i(paste.center[0]+8,paste.center[1]+8);
		glEnd();
		glColor3f(0,0,0.5);
		glBegin(GL_QUADS);
		glVertex2i(next.center[0]-8,next.center[1]+8);
		glVertex2i(next.center[0]-8,next.center[1]-8);
		glVertex2i(next.center[0]+8,next.center[1]-8);
		glVertex2i(next.center[0]+8,next.center[1]+8);
		glEnd();
	}
}

void importcolours(){
	int colbuff;
	FILE *fp;
	char pathname[256];
	getcwd(pathname,256);
	strcat(pathname,"\\importcolours.txt");
	fp = fopen(pathname, "r");
	for(int j=0;j<4;j++){
		for(int i=0;i<4;i++){
			colbuff=(fgetc(fp)-'0')*100;
			colbuff+=(fgetc(fp)-'0')*10;
			colbuff+=(fgetc(fp)-'0');
			trgb[j][i]=((double)colbuff)/255;
			colbuff=0;
			fgetc(fp);
		}
	}
	fclose(fp);
}

void import(){
	int skip=0;
	char pathname[256], buff;
	getcwd(pathname,256);
	strcat(pathname,"\\import.txt");
	fp = fopen(pathname, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			texture[i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
}

void load(){
	int skip=0;
	char pathname[256], buff;
	if(!mode){
		getcwd(pathname,256);
		strcat(pathname,"\\base.bin");
		fp = fopen(pathname, "r");
		fread(&focustexture, sizeof(spritetextures), 1, fp);
		fclose(fp);
		texture=focustexture.front[0];
		trgb[0][0]=focustexture.colour1[0];
		trgb[0][1]=focustexture.colour1[1];
		trgb[0][2]=focustexture.colour1[2];
		trgb[1][0]=focustexture.colour2[0];
		trgb[1][1]=focustexture.colour2[1];
		trgb[1][2]=focustexture.colour2[2];
		trgb[2][0]=focustexture.colour3[0];
		trgb[2][1]=focustexture.colour3[1];
		trgb[2][2]=focustexture.colour3[2];
		trgb[3][0]=focustexture.colour4[0];
		trgb[3][1]=focustexture.colour4[1];
		trgb[3][2]=focustexture.colour4[2];
	}else{
		getcwd(pathname,256);
		strcat(pathname,"\\base.bin");
		fp = fopen(pathname, "r");
		fread(&focustexture, sizeof(walltextures), 1, fp);
		fclose(fp);
		texture=focustexture.front[0];
		trgb[0][0]=focustexture.colour1[0];
		trgb[0][1]=focustexture.colour1[1];
		trgb[0][2]=focustexture.colour1[2];
		trgb[0][3]=focustexture.colour1[3];
		trgb[1][0]=focustexture.colour2[0];
		trgb[1][1]=focustexture.colour2[1];
		trgb[1][2]=focustexture.colour2[2];
		trgb[0][3]=focustexture.colour2[3];
		trgb[2][0]=focustexture.colour3[0];
		trgb[2][1]=focustexture.colour3[1];
		trgb[2][2]=focustexture.colour3[2];
		trgb[0][3]=focustexture.colour3[3];
		trgb[3][0]=focustexture.colour4[0];
		trgb[3][1]=focustexture.colour4[1];
		trgb[3][2]=focustexture.colour4[2];
		trgb[0][3]=focustexture.colour4[3];
	}
}

void init(){//initializes
	glClearColor(1,1,1,0);
	gluOrtho2D(0,scrwdth,scrhght,0);
	previous.center[0]=544;
	previous.center[1]=500;
	next.center[0]=544+30;
	next.center[1]=500;
	copy.center[0]=544+60;
	copy.center[1]=500;
	paste.center[0]=544+90;
	paste.center[1]=500;
	flip.center[0]=544+120;
	flip.center[1]=500;
}

void drawselect(){
	glColor3f(0.3,0.3,0.5);
	glRasterPos2f(15,15);
	glutBitmapCharacter(GLUT_BITMAP_8_BY_13,toggle+'0');
	
}

void drawlines(){
	for(int i=0;i<16;i++){
		glColor3f(0.5,0.5,0.5);
		glLineWidth(1);
		glBegin(GL_LINES);
		glVertex2i(i*32,0);
		glVertex2i(i*32,512);
		glEnd();
	}
		for(int i=0;i<16;i++){
		glColor3f(0,0,0);
		glLineWidth(1);
		glBegin(GL_LINES);
		glVertex2i(0,i*32);
		glVertex2i(512,i*32);
		glEnd();
	}
}

void drawsquares(){
	for(int i=0;i<16;i++){
		for(int j=0;j<16;j++){
			switch(texture[i*16+j]){
				case 0:
				if(!mode){
				glColor3f(trgb[0][0],trgb[0][1],trgb[0][2]);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');}
				break;
				case 1:
				glColor3f(trgb[!mode+0][0],trgb[!mode+0][1],trgb[!mode+0][2]);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 2:
				glColor3f(trgb[!mode+1][0],trgb[!mode+1][1],trgb[!mode+1][2]);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 3:
				glColor3f(trgb[!mode+2][0],trgb[!mode+2][1],trgb[!mode+2][2]);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 4:
				glColor3f(trgb[!mode+3][0],trgb[!mode+3][1],trgb[!mode+3][2]);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				default:
				glColor3f(0,0,0);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,'#');
				break;
			}
		}
	}
}

void drawsliders(){
	int ismode;
	int length;
	char modestr[64];
	ismode=!mode+3;
	for(int j=0;j<4;j++){
		for(int i=0;i<ismode;i++){
			glColor3f(0,0,0);
			glLineWidth(6);
			glBegin(GL_LINES);
			glVertex2i(544+32*i,32+96*j);
			glVertex2i(544+32*i,96+96*j);
			glEnd();
			sliders[j][i].center[0]=544+32*i;
			sliders[j][i].center[1]=32+96*j+trgb[j][i]*64;
			sliders[j][i].top=32+96*j;
			sliders[j][i].bottom=96+96*j;
			glBegin(GL_QUADS);
			glVertex2i(544-8+32*i,32+8+96*j+trgb[j][i]*64);
			glVertex2i(544+8+32*i,32+8+96*j+trgb[j][i]*64);
			glVertex2i(544+8+32*i,32-8+96*j+trgb[j][i]*64);
			glVertex2i(544-8+32*i,32-8+96*j+trgb[j][i]*64);
			glEnd();
		}
		glColor3f(trgb[j][0],trgb[j][1],trgb[j][2]);
		glBegin(GL_QUADS);
		glVertex2i(672,32+96*j);
		glVertex2i(672+64,32+96*j);
		glVertex2i(672+64,96+96*j);
		glVertex2i(672,96+96*j);
		glEnd();
	}
	if(mode){
		strcpy(modestr,"Mode is set to sprite");
		glColor3f(0,0,0);
		glRasterPos2f(544,448);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
	}else{
		strcpy(modestr,"Mode is set to wall");
		glColor3f(0,0,0);
		glRasterPos2f(544,448);
		length=strlen(modestr);
		for(int i=0;i<length;i++){
			glutBitmapCharacter(GLUT_BITMAP_8_BY_13,modestr[i]);
		}
	}
}

void save(){
	char pathname[256];
	if(mode){
		getcwd(pathname,256);
		strcat(pathname,"\\newspritetexture.bin");
		fp = fopen(pathname, "w");
		fwrite(&focustexture, sizeof(spritetextures), 1, fp);
		fclose(fp);
	}else{
		savewall.colour1[0]=trgb[0][0];
		savewall.colour1[1]=trgb[0][1];
		savewall.colour1[2]=trgb[0][2];
		savewall.colour1[3]=trgb[0][3];
		savewall.colour2[0]=trgb[1][0];
		savewall.colour2[1]=trgb[1][1];
		savewall.colour2[2]=trgb[1][2];
		savewall.colour2[3]=trgb[1][3];
		savewall.colour3[0]=trgb[2][0];
		savewall.colour3[1]=trgb[2][1];
		savewall.colour3[2]=trgb[2][2];
		savewall.colour3[3]=trgb[2][3];
		savewall.colour4[0]=trgb[3][0];
		savewall.colour4[1]=trgb[3][1];
		savewall.colour4[2]=trgb[3][2];
		savewall.colour4[3]=trgb[3][3];
		for(int i=0;i<256;i++){
			savewall.texture[i]=texture[i];
		}
		getcwd(pathname,256);
		strcat(pathname,"\\newwalltexture.bin");
		fp = fopen(pathname, "w");
		fwrite(&savewall, sizeof(walltextures), 1, fp);
		fclose(fp);	
	}
}

void mouse(int mousex, int mousey){
	for(int j=0;j<4;j++){
		for(int i=0;i<4;i++){
			if((mousex<sliders[j][i].center[0]+8)&&(mousex>sliders[j][i].center[0]-8)){
				if((mousey<sliders[j][i].center[1]+8)&&(mousey>sliders[j][i].center[1]-8)){
					if(mousey<sliders[j][i].bottom&&mousey>sliders[j][i].top){
						trgb[j][i]=(mousey-sliders[j][i].top)/64;
					}
				}
			}
		}
	}
	texture[mousey/32+mousex/32*16]=toggle;
	glutPostRedisplay();
}

void press(unsigned char key, int x, int y){
	if(key==' '){save();}
	if(key=='t'){mode=!mode;}
	if(key=='i'){importcolours();}
	if(key=='o'){import();}
	if(key=='+'){toggle++;toggle=toggle%6;}
	if(key=='-'){toggle--;toggle=(toggle+1)?toggle:5;}
	glutPostRedisplay();
}

void texswitch(){
	switch(spframe){
		case 0:
		texture=focustexture.front[0];
		break;
		case 1:
		texture=focustexture.front[1];
		break;
		case 2:
		texture=focustexture.front[2];
		break;
		case 3:
		texture=focustexture.back[0];
		break;
		case 4:
		texture=focustexture.back[1];
		break;
		case 5:
		texture=focustexture.back[2];
		break;
		case 6:
		texture=focustexture.left[0];
		break;
		case 7:
		texture=focustexture.left[1];
		break;
		case 8:
		texture=focustexture.left[2];
		break;
		case 9:
		texture=focustexture.right[0];
		break;
		case 10:
		texture=focustexture.right[1];
		break;
		case 11:
		texture=focustexture.right[2];
		break;
		case 12:
		texture=focustexture.dead;
		break;
	}
}

void display(){// display function
	glClear(GL_COLOR_BUFFER_BIT);
	if(lastframe!=spframe){
		texswitch();
		lastframe=spframe;
	}
	drawsquares();
	drawlines();
	drawselect();
	drawsliders();
	drawspecs();
	glutSetCursor(GLUT_CURSOR_CROSSHAIR);
	glutSwapBuffers();
}

void fliptex(){
	int hold;
	for(int i=0;i<8;i++){
		for(int j=0;j<16;j++){
		hold=texture[i*16+j];
		texture[i*16+j]=texture[240-i*16+j];
		texture[240-i*16+j]=hold;
		}
	}
}

void pastetex(){
	for(int i=0;i<256;i++){
		texture[i]=copytex[i];
	}
}

void click(int button, int state, int mousex, int mousey){
	if((button==GLUT_LEFT_BUTTON)&&(state==GLUT_DOWN)){
		texture[mousey/32+mousex/32*16]=toggle;
		if((mousex<previous.center[0]+8)&&(mousex>previous.center[0]-8)){
			if((mousey<previous.center[1]+8)&&(mousey>previous.center[1]-8)){
				spframe--;
				if(spframe<0){
					spframe=12;
				}
			}
		}
		if((mousex<next.center[0]+8)&&(mousex>next.center[0]-8)){
			if((mousey<next.center[1]+8)&&(mousey>next.center[1]-8)){
				spframe++;
				if(spframe>12){
					spframe=0;
				}
			}
		}
		if((mousex<copy.center[0]+8)&&(mousex>copy.center[0]-8)){
			if((mousey<copy.center[1]+8)&&(mousey>copy.center[1]-8)){
				copytex=texture;
			}
		}
		if((mousex<paste.center[0]+8)&&(mousex>paste.center[0]-8)){
			if((mousey<paste.center[1]+8)&&(mousey>paste.center[1]-8)){
				pastetex();
			}
		}
		if((mousex<flip.center[0]+8)&&(mousex>flip.center[0]-8)){
			if((mousey<flip.center[1]+8)&&(mousey>flip.center[1]-8)){
				fliptex();
			}
		}
	}
	glutPostRedisplay();
}

int main(int argc, char** argv){ 
	load();
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(scrwdth,scrhght);
	glutCreateWindow("ebic");
	glutMotionFunc(mouse);
	glutMouseFunc(click);
	init();
	glutKeyboardFunc(press);
	glutDisplayFunc(display);
	glutMainLoop();
}